DROP PACKAGE ADRMGT.STATS_UTIL;

CREATE OR REPLACE PACKAGE ADRMGT.STATS_UTIL
AUTHID CURRENT_USER
-- ###############################################################################
-- #  Description: 1750 - ADR create 1 table and 4 SPs for export/import stats
-- #
-- #   Usage:            Called by run_wrapper.sql
-- #   Input Parameters:
-- #     1) None
-- #   Output:
-- #     1) Terminal
-- #   Internal Script Parameters:
-- #     1) None
-- #
-- #
-- ###########################################################################
-- # Change History
-- #
-- # DATE       User Name         DESCRIPTION
-- # ---------- ----------------- -------------------------------------------------
-- # 01/30/2013 Richard Do        Created
-- #
-- #
-- ###########################################################################
AS

  VC_stattab        VARCHAR2(20):= 'STATS_TAB';
  VC_stattab_owner  VARCHAR2(100):= 'ADRMGT';
  VC_stattab_tbs    VARCHAR2(100):= 'M_DATA_01';
  VC_msg_log        VARCHAR2(200);



  -- ================= DECLARATIONS OF FUNCTION AND PROCEDURES =================

  FUNCTION VerifyTable (p_schemaname IN VARCHAR2, p_tablename  IN VARCHAR2) RETURN NUMBER;

  FUNCTION VerifySchema (p_schemaname IN VARCHAR2) RETURN NUMBER;

  PROCEDURE CreateStatTable(p_stattab VARCHAR2, p_statowner VARCHAR2);

  PROCEDURE ExportTabStats(p_ownname IN VARCHAR2, p_tabname IN VARCHAR2);

  PROCEDURE ExportSchemaStats(p_schemaname IN VARCHAR2);


  PROCEDURE ImportTabStats(p_ownname IN VARCHAR2, p_tabname IN VARCHAR2);

  PROCEDURE ImportSchemaStats(p_schemaname IN VARCHAR2);

END STATS_UTIL;
/

CREATE OR REPLACE PUBLIC SYNONYM STATS_UTIL FOR ADRMGT.STATS_UTIL;


GRANT EXECUTE ON ADRMGT.STATS_UTIL TO ADR;

GRANT EXECUTE ON ADRMGT.STATS_UTIL TO ADRAAP;

GRANT EXECUTE ON ADRMGT.STATS_UTIL TO ADREXT;

GRANT EXECUTE ON ADRMGT.STATS_UTIL TO ADRFILE;

GRANT EXECUTE ON ADRMGT.STATS_UTIL TO ADRREF;

GRANT EXECUTE ON ADRMGT.STATS_UTIL TO ADRTMP;

GRANT EXECUTE ON ADRMGT.STATS_UTIL TO BENS;

GRANT EXECUTE ON ADRMGT.STATS_UTIL TO CIS;

GRANT EXECUTE ON ADRMGT.STATS_UTIL TO EESRV;

GRANT EXECUTE ON ADRMGT.STATS_UTIL TO ESRJMS;

GRANT EXECUTE ON ADRMGT.STATS_UTIL TO IDHADM02;

GRANT EXECUTE ON ADRMGT.STATS_UTIL TO LOBR;

GRANT EXECUTE ON ADRMGT.STATS_UTIL TO ODM;

GRANT EXECUTE ON ADRMGT.STATS_UTIL TO PSIM;

GRANT EXECUTE ON ADRMGT.STATS_UTIL TO VBR;

GRANT EXECUTE ON ADRMGT.STATS_UTIL TO VOA;
